@echo off
rem ***********************************************************************************
rem **************BitSight Nightly Launcher Batch File**************
rem **************Version: 1.0
rem ***********************************************************************************

rem SET Archer Instance name here
set ArcherInstanceName=Dev

rem NOTE: Script current working directory ("Start in" if using Windows Task Scheduler) needs to be where this batch file and node files exist.
rem Get the current directory
set BitSightPath=%CD%

rem Get date time stamp for log file
set t=%date%_%time% 
set d=%t:~10,4%%t:~4,2%%t:~7,2%_%t:~15,2%%t:~18,2%
set d=%d: =0%

rem Create log file directory if it doesn't already exist
md "%BitSightPath%\Logs" 2>nul
md "%BitSightPath%\Logs\Nightly" 2>nul
md "%BitSightPath%\Logs\200" 2>nul
md "%BitSightPath%\Logs\210" 2>nul
md "%BitSightPath%\Logs\220" 2>nul
md "%BitSightPath%\Logs\230" 2>nul
rem @ECHO Completed setting up log directories

rem Set the log file name
set logfile="%BitSightPath%\Logs\Nightly\NightlyOverall_%d%.txt"

rem Clean up existing error files if they exist
IF EXIST "%BitSightPath%\Logs\error-200.txt" (
  DEL "%BitSightPath%\Logs\error-200.txt"
)
IF EXIST "%BitSightPath%\Logs\error-210.txt" (
  DEL "%BitSightPath%\Logs\error-210.txt"
)
IF EXIST "%BitSightPath%\Logs\error-220.txt" (
  DEL "%BitSightPath%\Logs\error-220.txt"
)
IF EXIST "%BitSightPath%\Logs\error-230.txt" (
  DEL "%BitSightPath%\Logs\error-230.txt"
)

rem Clean up existing success files if they exist
IF EXIST "%BitSightPath%\Logs\success-200.txt" (
  DEL "%BitSightPath%\Logs\success-200.txt"
)
IF EXIST "%BitSightPath%\Logs\success-210.txt" (
  DEL "%BitSightPath%\Logs\success-210.txt"
)
IF EXIST "%BitSightPath%\Logs\success-220.txt" (
  DEL "%BitSightPath%\Logs\success-220.txt"
)
IF EXIST "%BitSightPath%\Logs\success-230.txt" (
  DEL "%BitSightPath%\Logs\success-230.txt"
)


rem Launch 200 script
echo %BitSightPath%\200-BitSightSubscriptions.js Starting... >> %logfile% 2>&1
node "%BitSightPath%\200-BitSightSubscriptions.js" > "%BitSightPath%\Logs\200-BitSightSubscriptions.log" 2>&1

set errFound=0
IF EXIST "%BitSightPath%\Logs\error-200.txt" (
	set errFound=1
	echo "Error with 200 - Error Log found"
)

IF NOT EXIST "%BitSightPath%\Logs\success-200.txt" (
	set errFound=1
	echo "Error with 200 - Success Log not found"
)


rem Launch 210 script
echo %BitSightPath%\210-BitSightGetHeadlineRatingsNightly.js Starting... >> %logfile% 2>&1
node "%BitSightPath%\210-BitSightGetHeadlineRatingsNightly.js" > "%BitSightPath%\Logs\210-BitSightGetHeadlineRatingsNightly.log" 2>&1

IF EXIST "%BitSightPath%\Logs\error-210.txt" (
	set errFound=1
	echo "Error with 210 - Error Log found"
)

IF NOT EXIST "%BitSightPath%\Logs\success-210.txt" (
	set errFound=1
	echo "Error with 210 - Success Log not found"
)


rem Launch 220 script
echo %BitSightPath%\220-PublicDisclosures.js Starting... >> %logfile% 2>&1
node "%BitSightPath%\220-PublicDisclosures.js" > "%BitSightPath%\Logs\220-PublicDisclosures.log" 2>&1

IF EXIST "%BitSightPath%\Logs\error-220.txt" (
	set errFound=1
	echo "Error with 220 - Error Log found"
)

IF NOT EXIST "%BitSightPath%\Logs\success-220.txt" (
	set errFound=1
	echo "Error with 220 - Success Log not found"
)


rem Launch 230 script
echo %BitSightPath%\230-Alerts.js Starting... >> %logfile% 2>&1
node "%BitSightPath%\230-Alerts.js" > "%BitSightPath%\Logs\230-Alerts.log" 2>&1

IF EXIST "%BitSightPath%\Logs\error-230.txt" (
	set errFound=1
	echo "Error with 230 - Error Log found"
)

IF NOT EXIST "%BitSightPath%\Logs\success-230.txt" (
	set errFound=1
	echo "Error with 230 - Success Log not found"
)

rem Check if error file exists
IF %errFound%==1 (
	echo Overall Error! >> %logfile% 2>&1
	rem UNCOMMENT to send an email or other logging activity if desired
	rem Powershell.exe -File "%BitSightPath%\sendmailNightly.ps1" "Host Server: %COMPUTERNAME%<br>Archer Instance: %ArcherInstanceName%<br>Log File: %logfile%" 
	
	rem Format this text to anything for monitoring/alerts
	echo ERROR: BitSight Nightly Job - Execution Server: %COMPUTERNAME% - Archer Instance: %ArcherInstanceName% - Log file: %logfile%
) ELSE (
	echo Overall Success! >> %logfile% 2>&1
	echo SUCCESS
)
